# Vibe Coding 小程序开发

你好，我是鱼皮。

在前面的文章中，我们做了 Web 应用，这些应用可以在浏览器中访问。现在，让我们学习如何开发微信小程序，让你的应用可以在微信中运行。

微信小程序是一种不需要下载安装就能使用的应用，它依托于微信这个超级 APP，拥有庞大的用户基础。对于个人开发者来说，小程序是一个很好的展示平台，开发成本低，用户触达容易。

这篇文章，我会带你做 2 个实用的小程序：记账小程序和打卡小程序。同时，我会详细讲解小程序的开发流程和上线全流程，让你能够独立完成一个小程序从开发到上线的全过程。

需要先说明的是，本节教程更多的是做一个思路和项目开发流程的指导，目的是引导大家学会使用 Vibe Coding 开发项目的方法，需要大家自行动手实践。如果你需要更完整的 Vibe Coding 图文和视频教程，可以看看鱼皮的原创项目实战部分。



## 一、小程序开发基础

在开始做项目之前，先了解一下小程序开发的基础知识。

小程序是一种轻量级的应用，不需要下载安装，用完即走。微信小程序是最流行的小程序平台，还有支付宝小程序、抖音小程序等。小程序的优势在于：开发成本低（相比原生 APP）、用户触达容易（微信用户基数大）、审核相对宽松、可以快速迭代。

小程序和 Web 应用有什么区别？

简单来说，小程序运行在微信环境中，有一些特殊的 API 和限制。比如小程序可以调用微信的支付、分享、扫码等功能，但不能直接访问外部链接。从开发角度看，小程序使用的是类似 Vue 的语法，有自己的组件系统和生命周期。**如果你会 Web 开发，学习小程序会很快。**

微信小程序使用的技术栈包括：WXML（类似 HTML）、WXSS（类似 CSS）、JavaScript。可以使用原生开发，也可以使用框架（如 Taro、uni-app）来开发跨平台小程序。对于 Vibe Coding 来说，我推荐使用原生开发，因为 AI 对原生语法的支持更好，生成的代码质量更高。

开发小程序需要准备几样东西：

- 微信开发者账号（免费注册）
- 微信开发者工具（官方提供的 IDE）
- 一个项目创意

![微信开发者工具](https://pic.yupi.icu/1/image-20260112150540207.png)

注册账号很简单，去微信公众平台注册一个小程序账号，选择个人类型即可。下载开发者工具也很简单，去官网下载对应系统的版本。

用 Vibe Coding 开发小程序和开发 Web 应用类似，只是语法稍有不同。你需要告诉 AI 你在开发微信小程序，它会生成符合小程序规范的代码。比如，你可以说：“请用微信小程序原生语法创建一个记账页面，包含金额输入、分类选择、备注输入。” AI 会生成 WXML、WXSS 和 JS 文件。

💡 如果你想系统学习小程序开发，可以阅读鱼皮在编程导航上 [免费的保姆级小程序学习路线](https://www.codefather.cn/course/1789189862986850306/section/1789190355448471554)。



## 二、项目实战 - 记账小程序

记账是一个很实用的功能，很多人都有记账的需求。做一个记账小程序，可以学习小程序的基本开发流程，包括数据存储、页面跳转、组件使用等。

这个记账小程序要实现基本的记账功能。用户可以添加收支记录，包括金额、类型（收入/支出）、分类（餐饮、交通、工资等）、备注、日期。首页显示记录列表和统计数据（本月收入、支出、结余）。支持按日期筛选记录。数据存储在本地，使用微信的本地存储 API。

![](https://pic.yupi.icu/1/demoweb13.png)

使用微信小程序原生开发，不使用任何框架。数据存储使用 `wx.setStorageSync` 和 `wx.getStorageSync`。



### 开发步骤

1）第一步是注册小程序账号。去 [微信公众平台](https://mp.weixin.qq.com/) 注册一个小程序账号。选择个人类型，填写基本信息，完成注册。注册后会得到一个 AppID，开发时需要用到。

2）第二步是下载开发者工具。去 [微信开放文档](https://developers.weixin.qq.com/miniprogram/dev/devtools/download.html) 下载微信开发者工具，安装后用微信扫码登录。

3）第三步是创建项目。打开开发者工具，点击新建项目，填写项目名称，选择项目目录，填入 AppID，选择不使用云服务。点击确定，会自动生成一个小程序项目模板。

4）第四步是了解项目结构。小程序项目的基本结构包括：

- pages 目录：存放页面，每个页面有 wxml（页面结构）、wxss（页面样式）、js（页面逻辑）、json（页面配置）四个文件
- utils 目录：存放工具函数
- app.js：小程序逻辑
- app.json：小程序配置
- app.wxss：全局样式

5）现在可以用 Cursor 打开项目目录，开始和 AI 对话开发。

首先设计数据结构：

```
我要开发一个记账小程序，请帮我设计数据结构。

需要存储的信息：
- 金额
- 类型（收入/支出）
- 分类（餐饮、交通、购物、工资等）
- 备注
- 日期

请给出 JavaScript 对象的结构。
```

AI 会帮你设计合理的数据结构，包括每个字段的类型和说明。

然后创建首页：

```
请用微信小程序原生语法创建首页（pages/index/index）：

顶部显示统计卡片：
- 本月收入（绿色）
- 本月支出（红色）
- 本月结余（蓝色）

中间显示记录列表：
- 按日期分组显示
- 每条记录显示：分类图标、分类名称、备注、金额
- 收入显示绿色，支出显示红色

底部有一个大的"+"按钮，点击跳转到添加页面。

使用 Flex 布局，界面要美观。
```

这个提示词详细说明了首页的布局和样式。AI 会生成完整的 WXML、WXSS 和 JS 代码。

接着实现数据存储：

```
创建 utils/storage.js 工具文件，封装数据存储操作：

1. saveRecord(record)：保存一条记录
2. getRecords()：获取所有记录
3. deleteRecord(id)：删除一条记录
4. getMonthRecords(year, month)：获取指定月份的记录

使用 wx.setStorageSync 和 wx.getStorageSync 存储数据。
记录要有唯一 ID（可以用时间戳）。
```

这样就把数据存储逻辑封装好了，后面用起来很方便。

然后创建添加页面：

```
创建添加记录页面（pages/add/add）：

顶部有两个 Tab：收入、支出

金额输入区：
- 大号的金额输入框
- 显示"¥"符号

分类选择区：
- 宫格布局显示分类图标
- 收入分类：工资、奖金、理财、其他
- 支出分类：餐饮、交通、购物、娱乐、医疗、其他
- 选中的分类高亮显示

备注输入：
- 单行文本输入框

日期选择：
- 默认今天
- 点击可以选择日期

底部保存按钮：
- 点击保存记录并返回首页
```

接着实现统计功能：

```
在首页实现统计功能：

1. 计算本月总收入：筛选本月的收入记录，求和
2. 计算本月总支出：筛选本月的支出记录，求和
3. 计算本月结余：收入 - 支出

在页面加载时和返回时刷新统计数据。
```

最后实现记录列表：

```
在首页实现记录列表：

1. 获取所有记录，按日期倒序排列
2. 按日期分组显示（今天、昨天、更早）
3. 每条记录显示分类图标、名称、备注、金额
4. 长按记录可以删除

实现下拉刷新功能。
```



### 开发技巧

在开发小程序时，有几个技巧可以提高效率。首先，要利用好微信开发者工具的调试功能。可以在模拟器中预览效果，也可以在真机上预览。真机预览需要用微信扫码，可以看到真实的运行效果。

其次，小程序的数据存储是同步的，使用 `wx.setStorageSync` 和 `wx.getStorageSync`。如果数据量大，建议使用异步版本 `wx.setStorage` 和 `wx.getStorage`，避免阻塞主线程。

另外，小程序的页面跳转有几种方式：`wx.navigateTo`（保留当前页面，可以返回）、`wx.redirectTo`（关闭当前页面，不能返回）、`wx.switchTab`（跳转到 tabBar 页面）、`wx.navigateBack`（返回上一页）。要根据场景选择合适的方式。

最后，小程序有一些限制，比如包大小不能超过 2MB（分包后每个包不超过 2MB），要注意控制图片大小和代码体积。可以使用图片压缩工具压缩图片，使用代码分包功能拆分代码。



### 扩展思路

基础版完成后，可以继续扩展功能。比如添加预算设置，设置每月预算，超支时提醒；添加图表展示，用图表显示收支趋势；支持分类管理，用户可以自定义分类；添加账单导出，导出为 Excel 文件；支持多账本，可以创建工作账本、生活账本等；集成云同步，使用微信云开发实现多设备同步。



## 三、项目实战 - 打卡小程序

完成了记账小程序后，让我们来做一个涉及日历和数据可视化的项目。打卡是一个很好的习惯养成工具，很多人用打卡来坚持学习、运动、早起等。做一个打卡小程序，可以学习小程序的日历组件、数据可视化等功能。

这个打卡小程序要实现习惯打卡功能。用户可以创建打卡项目（比如每天学习、每天运动），设置打卡目标（连续打卡天数）。每天可以打卡一次，打卡后显示打卡成功。首页显示所有打卡项目和打卡状态。日历视图显示打卡历史，打卡的日期标记为绿色。统计数据显示总打卡天数、连续打卡天数、完成率等。

![](https://pic.yupi.icu/1/demoweb14.png)

使用微信小程序原生开发，数据存储使用本地存储。日历组件可以使用第三方组件库（如 Vant Weapp）或自己实现。



### 开发步骤

1）开发的第一步是设计数据结构。告诉 AI：

```
我要开发一个打卡小程序，请帮我设计数据结构。

打卡项目：
- id
- name（项目名称，如"每天学习"）
- target（目标天数）
- created_at（创建时间）

打卡记录：
- id
- project_id（关联的项目）
- date（打卡日期，格式 YYYY-MM-DD）
- note（打卡备注，可选）
- created_at（打卡时间）

请给出数据结构和存储方案。
```

AI 会帮你设计合理的数据结构，并说明如何存储在本地。

2）创建项目列表页

告诉 AI：

```
创建首页（pages/index/index），显示打卡项目列表：

每个项目卡片显示：
- 项目名称
- 今日是否已打卡（已打卡显示绿色勾，未打卡显示灰色圆圈）
- 连续打卡天数
- 总打卡天数
- 进度条（已打卡天数/目标天数）

底部有"添加项目"按钮。

点击项目卡片进入项目详情页。
点击打卡按钮进行打卡。
```

这个提示词说明了首页的布局和交互。AI 会生成完整的页面代码。

3）实现打卡功能

告诉 AI：

```
实现打卡功能：

1. 检查今天是否已打卡
2. 如果未打卡，创建打卡记录
3. 保存到本地存储
4. 显示打卡成功提示
5. 刷新页面数据

打卡时可以添加备注（可选）。
```

打卡功能要防止重复打卡，所以要先检查今天是否已打卡。

4）创建项目详情页

告诉 AI：

```
创建项目详情页（pages/detail/detail）：

顶部显示项目信息：
- 项目名称
- 目标天数
- 已打卡天数
- 连续打卡天数

中间显示日历：
- 显示当前月份
- 打卡的日期标记为绿色
- 今天标记为蓝色边框
- 可以切换月份

底部显示打卡记录列表：
- 按日期倒序显示
- 显示日期、备注

右上角有删除项目按钮。
```

5）实现统计功能

告诉 AI：

```
实现统计功能：

1. 总打卡天数：该项目的所有打卡记录数
2. 连续打卡天数：从今天往前数，连续打卡的天数
3. 完成率：已打卡天数 / 目标天数
4. 最长连续打卡：历史上最长的连续打卡天数

在项目详情页显示这些统计数据。
```

连续打卡天数的计算比较复杂，要从今天往前遍历，检查每一天是否有打卡记录，直到遇到没有打卡的日期。AI 会帮你实现这个算法。

6）实现日历组件

告诉 AI：

```
实现日历组件：

1. 显示当前月份的所有日期
2. 打卡的日期标记为绿色背景
3. 今天标记为蓝色边框
4. 可以切换上个月/下个月
5. 点击日期可以查看当天的打卡备注

使用 Grid 布局，每行 7 个日期（周日到周六）。
```

日历组件的实现比较复杂，但 AI 可以帮你搞定。如果觉得自己实现太麻烦，也可以使用第三方组件库，比如 Vant Weapp。



### 开发技巧

在开发打卡小程序时，有几个技巧需要注意。首先是日期处理，JavaScript 的日期处理比较复杂，可以让 AI 帮你封装一些工具函数，比如获取当月天数、判断是否是今天、计算两个日期的天数差等。

其次是连续打卡天数的计算。要从今天往前遍历，检查每一天是否有打卡记录，直到遇到没有打卡的日期。可以让 AI 帮你实现这个算法，它会考虑各种边界情况。

另外，日历组件的实现比较复杂，如果觉得自己实现太麻烦，可以使用第三方组件库。Vant Weapp 是一个很好的小程序 UI 组件库，提供了日历组件。可以让 AI 帮你集成 Vant Weapp，使用它提供的日历组件。

最后，打卡数据可能会越来越多，要注意性能优化。可以只加载最近 3 个月的数据，更早的数据按需加载，避免一次性加载太多数据导致页面卡顿。



### 扩展思路

基础版完成后，可以继续扩展功能。比如添加打卡提醒，每天定时提醒用户打卡；实现打卡分享，生成打卡海报分享到朋友圈；添加打卡排行榜，和好友比拼谁坚持得更久；实现打卡奖励，连续打卡获得勋章；支持数据导出，导出打卡记录；集成云同步，使用微信云开发实现多设备同步。



## 四、小程序上线全流程

开发完成后，如何让小程序上线呢？这里详细讲解小程序的上线流程。

1）完善小程序信息

在微信公众平台，完善小程序的基本信息：小程序名称、简介、头像、类目（选择合适的类目）。个人类型的小程序有一些限制，比如不能使用支付功能、不能使用某些类目。如果需要这些功能，需要注册企业类型。

2）配置服务器域名

如果小程序需要调用后端 API，需要在微信公众平台配置服务器域名。只有配置了的域名才能在小程序中访问。注意，域名必须是 HTTPS 的，需要有 SSL 证书。如果是本地开发，可以在开发者工具中勾选"不校验合法域名"。

3）上传代码

在微信开发者工具中，点击右上角的 “上传” 按钮，填写版本号和项目备注，点击上传。上传后，代码会提交到微信服务器。

4）提交审核

在微信公众平台，进入 “版本管理”，可以看到刚才上传的版本。点击"提交审核"，填写审核信息。审核信息包括：测试账号（如果需要登录）、测试说明（告诉审核人员如何测试）、隐私相关说明等。提交后，等待审核。审核时间说是 1 ~ 7 天，一般 1 ~ 2 天就能审核通过。

5）发布上线

审核通过后，会收到通知。在微信公众平台，点击 “发布” 按钮，小程序就正式上线了。上线后，用户可以通过搜索、扫码、分享等方式访问你的小程序。

6）版本更新

如果要更新小程序，重复上面的流程：上传代码 → 提交审核 → 发布上线。可以使用 “分阶段发布” 功能，先发布给部分用户，测试没问题后再全量发布。

![](https://pic.yupi.icu/1/weapp-workflow%E5%A4%A7.jpeg)



### 常见审核问题

小程序审核可能会遇到一些问题，这里列举几个常见的。

1）功能不完整。审核人员发现功能无法正常使用，比如点击按钮没反应、页面显示错误等。要确保所有功能都能正常使用，提交前自己先完整测试一遍。

第二个是类目不符。小程序的功能和选择的类目不符。比如你做的是工具类小程序，但选择了社交类目。要选择合适的类目，如果不确定，可以咨询微信客服。

缺少必要说明。比如小程序需要获取用户位置，但没有说明用途。要在隐私政策中说明清楚，为什么需要这些权限，如何使用这些数据。

4）内容违规。小程序的内容违反了微信的规范，比如包含不当内容。要仔细阅读微信小程序运营规范，确保内容合规。

如果审核不通过，会收到拒绝原因。根据原因修改后，重新提交审核即可。

**不要灰心，很多小程序第一次都会被拒绝，这是正常的。**



## 五、我上线《学习英雄》小程序的经历

最后，我想分享一下我上线《学习英雄》小程序的真实经历，希望能给你一些启发。

《学习英雄》是一个 AI 问答引导式学习小程序，用户可以输入想学习的主题，AI 自动生成相关的知识问答卡片，通过闯关答题的形式引导用户更轻松愉快地掌握知识。

![](https://pic.yupi.icu/1/%25E5%25B0%258F%25E7%25A8%258B%25E5%25BA%258F%25E6%25BC%2594%25E7%25A4%25BA%25E6%258B%25BC%25E5%259B%25BE.png)

开发过程其实很快，用 AI 编程工具，基本上 1 天就完成了包含完整前后端和 AI 能力的小程序。但是你敢信，我竟然花了差不多 2 个月，才把这个小程序正式上线？！

换到以前，我自己都不敢相信，记得大学的时候上线个小程序很快的，看来真的是时代变了。



### 完整的上线流程

1）小程序备案

以前压根儿是没有这一步的，但是自 2023 年 9 月 1 日起，所有新开发的微信小程序必须完成备案后才能上架。

备案操作是免费的，主要就是在后台填写一些个人/企业信息。但是审核周期大约 2 ~ 22 个工作日（含工信部审核）。我是在国庆节前提了备案，过了 12 天后才通过；如果不是假期，可能会快点吧。

2）小程序类目申请

由于我的小程序用到了 AI 大模型来做问答功能，需要添加 “深度合成-AI 问答类目”，否则无法通过代码发布审核。

![](https://pic.yupi.icu/1/image-20251203212944981.png)

那我就按照修改指引添加类目呗，结果添加 AI 相关的类目是需要资质文件的！因为我用的是别人的大模型，需要有技术主体的《互联网信息服务算法备案》和《小程序主体与技术主体的合作协议》。

![](https://pic.yupi.icu/1/5b7bf1460d71ff74477082606e6e7cf8.png)

什么？还要合作协议？！到这一步我估计会劝退一大波萌新，我刚看到的时候也头疼了。

![](https://pic.yupi.icu/1/image-20251203215116730.png)

不过别慌，你用哪家的 AI 大模型服务，就直接去找对应的工作人员要就好了。比如我用的是阿里云大模型，直接去官网联系客服，他们的技术支持响应很快，也很热心。你只需要做到把自己的需求描述清楚，对方会帮你处理的。

![](https://pic.yupi.icu/1/image-20251203195218556.png)

大概花费了 10 天左右，我顺利拿到了申请类目的材料，提交申请就好。

3）代码发布审核

感觉现在小程序的审核越来越严格了，尤其是刚开始做的小程序，很容易因为一些意想不到的原因被打回来。

比如我遇到的这个情况，由于小程序的某个按钮点击后没有响应，就被打回来了。

![](https://pic.yupi.icu/1/%25E5%25B0%258F%25E7%25A8%258B%25E5%25BA%258F%25E5%25AE%25A1%25E6%25A0%25B8-%25E4%25B8%258D%25E9%2580%259A%25E8%25BF%2587%25E7%259A%2584%25E5%258E%259F%25E5%259B%25A0.png)

这锅我不背，谁让 AI 偷懒了呢？！

于是我让团队的同学帮忙补了个点击弹窗，然后重新提交了审核。

![](https://pic.yupi.icu/1/%E5%B0%8F%E7%A8%8B%E5%BA%8F%E5%AE%A1%E6%A0%B8-%E8%A1%A5%E4%BA%86%E4%B8%AA%E5%85%B3%E4%BA%8E%E6%88%91%E4%BB%AC%E7%9A%84%E4%BF%A1%E6%81%AF.png)

经过 2 ~ 3 天左右，代码审核终于通过了。

4）然而由于我的小程序还涉及 “社交” 类目，需要进入第四步：小程序报备。

![](https://pic.yupi.icu/1/image-20251203214139938.png)

当时看到这个 7 天 * 24h 的审核时长，我嘴里正在撕咬的鸡腿都变得索然无味了。。。

好在过了 7 天后，我的小程序终于发布上线了，真是不容易啊！

来回顾下完整的流程吧：

![](https://pic.yupi.icu/1/image-20251203195031382.png)



### 经验总结

虽然我这次小程序上线花了近 2 个月，但其实中间有些空余的时间是我自己没来得及看到通知。不过就算只考虑必须的流程，差不多也要 1 个月了。

如果你只是想做个简单的工具小程序，不涉及 AI 功能和需要报备的类目（比如社交、金融、医疗等），应该能省不少时间。

![](https://pic.yupi.icu/1/0.png)

不过我估计现在很多同学都有用 AI 做个《有 AI 功能的小程序》的想法，所以还是建议大家：

1. 提前申请小程序的类目：如果涉及 AI 功能，尽早准备资质材料
2. 先搞出最小可用版本：做一个 Demo 拿来过审、走完一次上线发布的流程
3. 统筹安排时间：开发可能只要几天，但上线流程可能要几周甚至几个月
4. 审核前充分测试：确保所有功能正常，避免因为小问题被打回
5. 详细说明测试流程：提供测试账号和详细的测试说明



## 写在最后

通过这 2 个小程序项目，你已经学习了小程序开发的基本流程。更重要的是，你学会了如何把项目上线，让真实的用户使用。

小程序开发相比 Web 开发有一些特殊之处，但核心思路是相通的。用 Vibe Coding 的方式，你可以快速开发出功能完整的小程序。如果你想学习更多的小程序开发技巧和最佳实践，可以参考本教程的经验技巧板块。

完成了小程序开发后，在下一篇文章中，我会教你如何把各种项目部署到互联网上，让全世界的人都能访问你的作品。



## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
